		% Example 5.8 Linear-phase, equiripple lowpass FIR 
		
		% Author: 			Lars Wanhammar 2004-07-29
		% Modified by: 	 	TS 2017-10-11
		% Copyright:		by authors - not released for commercial use
		% Version:			1 
		% Known bugs:		None
		% Report bugs to:	lars.wanhammar@liu.se
		%
		clear all
		close all
		wTedges = [0.3 0.6]*pi;			% Band edges
		b = [1 0]; 						% Gains in the bands
		d = [0.02 0.0025]; 				% Acceptable deviations
		Amaxreq = 20*log10(1+0.02/(1-0.02))
		Aminreq = 20*log10((1+0.02)/0.0025)
		% Estimate filter order	
		[N, Be, D, W] = L_PHASE_LP_FIR_ORDER(wTedges, d);
		W = [1 4]	% Yields an acceptable solution
		N 			%  Estimated order = 15
		N = N+1		% Minimum order (16) to meet the criteria
		Ftype = 'm';	
		[h, Err] = REMEZ_FIR(N, Be, D, W, Ftype, {128});  
		deltac = Err/W(1); 			% Resulting passband and
		deltas = Err/W(2); 			% Stopband ripples
		hn = h/(1+deltac);		 	% Normalize the max gain to 1
		fprintf('Err= %2.8f \n', Err);
		Amax = 20*log10((1+deltac)/(1-deltac));
		Amin = 20*log10((1+deltac)/deltas);
		fprintf('Amax = %2.6f dB \n', Amax)
		fprintf('Amin = %2.4f dB \n', Amin);
		wT = linspace(0, pi, 2000);		 	% wT axis 0 to  rad
		Mag = H_2_MAG(freqz(hn, 1, wT)); 	% Magnitude in dB
		opt = 'Mag';
		PLOT_MAG_PZ_h_FIR(wT, Mag, hn, Be, D, d, opt) 
		
		h'
		
		
